---
generated_at: 2026-02-02 10:03:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：4-Pod GC Controller バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **gcUnscheduledTerminating処理の詳細**：関数の実装が読み取り範囲外

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/podgc/gc_controller.go` - 定数定義（L46-L52）
- E-02: `pkg/controller/podgc/gc_controller.go` - PodGCController構造体（L54-L67）
- E-03: `pkg/controller/podgc/gc_controller.go` - NewPodGC/NewPodGCInternal関数（L69-L92）
- E-04: `pkg/controller/podgc/gc_controller.go` - Run関数（L94-L115）
- E-05: `pkg/controller/podgc/gc_controller.go` - gc関数（L117-L134）
- E-06: `pkg/controller/podgc/gc_controller.go` - gcTerminating関数（L148-L191）
- E-07: `pkg/controller/podgc/gc_controller.go` - gcTerminated/isPodTerminated/isPodTerminating（L136-L200）
- E-08: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - No.4 エントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | gcCheckPeriod = 20秒 | E-01 | ○ |
| C-02 | quarantineTime = 40秒 | E-01 | ○ |
| C-03 | PodGCController構造体がkubeClient, podLister, nodeLister, nodeQueue等を保持 | E-02 | ○ |
| C-04 | terminatedPodThresholdフィールドの存在 | E-02 | ○ |
| C-05 | NewPodGCInternal関数での初期化 | E-03 | ○ |
| C-06 | metrics.RegisterMetrics()の呼び出し | E-03 | ○ |
| C-07 | Run関数でキャッシュ同期後にgcループ起動 | E-04 | ○ |
| C-08 | wait.UntilWithContextでgcCheckPeriod周期実行 | E-04 | ○ |
| C-09 | gc関数で全Pod/Node一覧取得 | E-05 | ○ |
| C-10 | terminatedPodThreshold > 0でgcTerminated実行 | E-05 | ○ |
| C-11 | gcTerminating, gcOrphaned, gcUnscheduledTerminatingの呼び出し順 | E-05 | ○ |
| C-12 | isPodTerminated: PhaseがPending/Running/Unknown以外 | E-07 | ○ |
| C-13 | isPodTerminating: DeletionTimestamp != nil | E-07 | ○ |
| C-14 | gcTerminating: out-of-service taintとNotReady判定 | E-06 | ○ |
| C-15 | markFailedAndDeletePod: 削除前にFailedマーク | E-06 | ○ |
| C-16 | byEvictionAndCreationTimestampによるソート | E-06 | ○ |
| C-17 | sync.WaitGroupによる並行Pod削除 | E-06 | ○ |
| C-18 | DeletingPodsTotal/DeletingPodsErrorTotalメトリクス | E-06 | ○ |
| C-19 | nodeQueueの使用（TypedDelayingInterface） | E-02, E-03 | ○ |
| C-20 | gcUnscheduledTerminatingの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- gcUnscheduledTerminating関数の実装は読み取り範囲外であり、未スケジュールのterminatingPod削除の詳細ロジックは未確認。
  - 候補：`pkg/controller/podgc/gc_controller.go` のL200以降

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラーの基本構造と主要GC関数は正確に記述
- 0: 低リスク - 定数値とGC実行順序はソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] gcOrphaned関数の実装（quarantineTimeの使用方法）を確認
- [ ] gcUnscheduledTerminating関数の実装を確認
- [ ] markFailedAndDeletePodの実装詳細を確認
- [ ] メトリクスラベル（namespace, reason）の正確性を確認
